/*
          
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                         JDF1.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Blue 
//----    --------------------------------------------------------------------------------------------------+
extern int Length = 5;   //   
extern int Phase  = 100; // ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//----  
int Filter_size=59; double Filter[1];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JDF1 initialization function                                     |
//+------------------------------------------------------------------+ 
int init() 
{ 
//----     
SetIndexStyle(0,DRAW_LINE); 
//----     
SetIndexBuffer(0,Ind_Buffer);
//----   ,      
SetIndexEmptyValue(0,0.0);  
//----    Filter[]
Filter_size=38;
int count=ArrayResize(Filter,Filter_size);
if(count==0){Alert("     Filter");return(0);}
//+===     
 Filter[0]=+0.17403451;
 Filter[1]=+0.16948128;
 Filter[2]=+0.16059816;
 Filter[3]=+0.14781486;
 Filter[4]=+0.13174065;
 Filter[5]=+0.11313871;
 Filter[6]=+0.09286711;
 Filter[7]=+0.07184032;
 Filter[8]=+0.05097190;
 Filter[9]=+0.03112691;
 Filter[10]=+0.01307061;
 Filter[11]=-0.00256166;
 Filter[12]=-0.01530251;
 Filter[13]=-0.02486646;
 Filter[14]=-0.03115430;
 Filter[15]=-0.03425059;
 Filter[16]=-0.03440925;
 Filter[17]=-0.03202465;
 Filter[18]=-0.02758893;
 Filter[19]=-0.02167731;
 Filter[20]=-0.01488347;
 Filter[21]=-0.00779524;
 Filter[22]=-0.00095266;
 Filter[23]=+0.00517940;
 Filter[24]=+0.01023922;
 Filter[25]=+0.01397635;
 Filter[26]=+0.01626220;
 Filter[27]=+0.01708655;
 Filter[28]=+0.01654358;
 Filter[29]=+0.01481635;
 Filter[30]=+0.01215917;
 Filter[31]=+0.00887676;
 Filter[32]=+0.00526401;
 Filter[33]=+0.00163806;
 Filter[34]=-0.00173046;
 Filter[35]=-0.00461265;
 Filter[36]=-0.00684073;
 Filter[37]=-0.00831200;
 Filter[38]=-0.00899435;
 Filter[39]=-0.00891770;
 Filter[40]=-0.00816700;
 Filter[41]=-0.00687156;
 Filter[42]=-0.00518670;
 Filter[43]=-0.00327689;
 Filter[44]=-0.00130327;
 Filter[45]=+0.00053100;
 Filter[46]=+0.00216298;
 Filter[47]=+0.00346508;
 Filter[48]=+0.00438724;
 Filter[49]=+0.00491006;
 Filter[50]=+0.00505159;
 Filter[51]=+0.00485999;
 Filter[52]=+0.00441031;
 Filter[53]=+0.00379387;
 Filter[54]=+0.00310922;
 Filter[55]=+0.00245712;
 Filter[56]=+0.00193159;
 Filter[57]=+0.00161549;
 Filter[58]=-0.00973188;
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
if (JJMASeriesResize(1)!=1)return(-1);
//----       
JJMASeriesAlert (0,"Length",Length);
JJMASeriesAlert (1,"Phase", Phase);
PriceSeriesAlert(Input_Price_Customs);
//----   ,       
SetIndexDrawBegin(0,Filter_size+30); 
//----  
return(0); 
}
//+------------------------------------------------------------------+ 
//| JDF1 iteration function                                          | 
//+------------------------------------------------------------------+  
int start()
   {
//----       
if(Bars-1<=Filter_size)return(0);
//----      
double FILTER,Resalt,Price;  
//----+        
int reset,MaxBar,limit,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,         
limit=Bars-counted_bars-1; MaxBar=Bars-1-Filter_size;
//----      ,         
//----            
if (limit>=MaxBar)
 {
  for(bar=limit;bar>=MaxBar;bar--)Ind_Buffer[bar]=0.0; 
  limit=MaxBar;
 }

//----+    
for(bar=limit;bar>=0;bar--)
 {
 FILTER=0.0;
  for(int ii=0;ii<=Filter_size;ii++)
   {
    //----+    PriceSeries     Series
    Price=PriceSeries(Input_Price_Customs, bar+ii);
    //----+    FATL
    FILTER=FILTER+Filter[ii]*Price;
   }
  //----+ JMA   ,  nJMA.MaxBar     nf
  //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
  Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,FILTER,bar,reset);
  //----+       
  if(reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
     //----+
 }
//----    
return(0); 
} 
//+------------------------------------------------------------------------+

